/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import sekelsta.horse_colors.breed.donkey.DefaultDonkey;
import sekelsta.horse_colors.breed.horse.DefaultHorse;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.ModEntities;
import sekelsta.horse_colors.entity.genetics.EquineGenome;
import sekelsta.horse_colors.entity.genetics.Species;

public class MuleGeneticEntity
extends AbstractHorseGenetic {
    protected static final DataParameter<Integer> SPECIES = EntityDataManager.func_187226_a(MuleGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("minecraft", "entities/mule");

    public MuleGeneticEntity(EntityType<? extends MuleGeneticEntity> entity, World world) {
        super(entity, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIES, (Object)Species.MULE.ordinal());
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Species", this.getSpecies().toString());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        throw new RuntimeException("Not yet implemented");
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    public boolean fluffyTail() {
        return true;
    }

    @Override
    public boolean longEars() {
        return true;
    }

    @Override
    public boolean thinMane() {
        return false;
    }

    public void setSpecies(Species species) {
        this.field_70180_af.func_187227_b(SPECIES, (Object)species.ordinal());
    }

    @Override
    public Species getSpecies() {
        return Species.values()[(Integer)this.field_70180_af.func_187225_a(SPECIES)];
    }

    protected boolean func_110200_cJ() {
        return false;
    }

    @Override
    public AbstractHorseEntity getChild(ServerWorld world, AgeableEntity ageable) {
        MuleGeneticEntity child = (MuleGeneticEntity)ModEntities.MULE_GENETIC.func_200721_a(this.field_70170_p);
        return child;
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187786_du;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187788_dv;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187790_dw;
    }

    protected void playChestEquipSound() {
        this.func_184185_a(SoundEvents.field_191259_dX, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    protected ITextComponent func_225513_by_() {
        if (!this.func_70631_g_()) {
            if (!((Boolean)HorseConfig.Breeding.enableGenders.get()).booleanValue() && this.getSpecies() == Species.HINNY) {
                String s = "entity.horse_colors.hinny";
                return new TranslationTextComponent(s);
            }
        }
        return super.func_225513_by_();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        EquineGenome horse = new EquineGenome(Species.HORSE);
        horse.randomize(DefaultHorse.breed);
        EquineGenome donkey = new EquineGenome(Species.DONKEY);
        donkey.randomize(DefaultDonkey.breed);
        this.genes.inheritGenes(horse, donkey);
        this.useGeneticAttributes();
        return spawnDataIn;
    }
}

